@ECHO OFF

REM Version History
REM 1.080 09/26/2019 Various Updates

SET FL_HEX="ICHEM_v1.080.a90"
COLOR 17

ECHO ************************************************************************
ECHO **  PENTAIR                                                           **
ECHO **  INTELLICHEM CHEMICAL CONTROLLER FIRMWARE UPDATE v1.080            **
ECHO ************************************************************************
ECHO **IMPORTANT NOTES!                                                    **
ECHO **  1. Please install the USB programmer driver before updating       **
ECHO **     the IntelliChem chemical controller firmware                   **
ECHO **  2. Support Windows 7, 8, 10                                       **
ECHO ************************************************************************

CD C:\Pentair\IntelliChem

Pause

REM ***********************************************************
REM ** Use this if it does not recognise the USB device name **
REM ** and then replace \\.\USBSER000 with COM%PORT%         **
REM ***********************************************************
REM ECHO What com port is your USB programmer connected to?
REM ECHO Please enter a number 1-75
REM SET /p PORT= COM:
REM ECHO COM%PORT%
setlocal EnableDelayedExpansion
set "WINDOWS_10="
for /f "tokens=4-5 delims=. " %%i in ('ver') do set VERSION=%%i.%%j
if "%version%" == "5.1" (
	echo "Windows XP"
)
if "%version%" == "6.3" (
	echo Windows 8.1
)
if "%version%" == "6.2" (
	echo Windows 8.
)
if "%version%" == "6.1" (
	echo Windows 7.
)
if "%version%" == "6.0" (
	echo Windows Vista.
)
	
if "%version%" == "10.0" (
	echo "WINDOWS 10"
	set WINDOWS_10=1
)
if DEFINED WINDOWS_10 (
	goto Windows10
) else (
	goto OtherWindows
)
REM echo %version%
REM etc etc
REM endlocal

REM echo %CPORT%
echo %FL_HEX%

:Windows10
	ECHO What com port is your USB programmer connected to?
	ECHO Please enter a number 1-75
	SET /P INPORT=COM
	SET COMSTRING=COM
	SET CPORT=%COMSTRING%%INPORT%
	REM echo %CPORT%
	avrdude -p m128 -P %CPORT% -c avrisp2 -B 3 -e -U flash:w:%FL_HEX% -U efuse:w:0xFF:m -U hfuse:w:0xD7:m -U lfuse:w:0x1F:m -U lock:w:0x00:m
goto:EOF

:OtherWindows
	echo "OTHERWINDOWS"
	SET CPORT=\\.\USBSER000
        echo %CPORT%
	avrdude -p m128 -P \\.\USBSER000 -c avrisp2 -B 3 -e -U flash:w:%FL_HEX% -U efuse:w:0xFF:m -U hfuse:w:0xD7:m -U lfuse:w:0x1F:m -U lock:w:0x00:m
goto:EOF


pause
